/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.data;

import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.montoyo.wd.client.gui.GuiServer;
import net.montoyo.wd.data.GuiData;
import net.montoyo.wd.net.BufferUtils;
import net.montoyo.wd.utilities.NameUUIDPair;
import net.montoyo.wd.utilities.Vector3i;

public class ServerData
extends GuiData {
    public Vector3i pos;
    public NameUUIDPair owner;

    public ServerData() {
    }

    public ServerData(BlockPos bp, NameUUIDPair owner) {
        this.pos = new Vector3i(bp);
        this.owner = owner;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Screen createGui(Screen old, Level world) {
        return new GuiServer(this.pos, this.owner);
    }

    @Override
    public String getName() {
        return "Server";
    }

    @Override
    public void serialize(FriendlyByteBuf buf) {
        BufferUtils.writeVec3i(buf, this.pos);
        this.owner.writeTo(buf);
    }

    @Override
    public void deserialize(FriendlyByteBuf buf) {
        this.pos = BufferUtils.readVec3i(buf);
        this.owner = new NameUUIDPair(buf);
    }
}

